/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.startgear;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.resource.SingleJsonFileReloadListener;
import dev.toma.gunsrpg.resource.adapter.GearAdapter;
import dev.toma.gunsrpg.resource.adapter.ItemStackAdapter;
import dev.toma.gunsrpg.resource.startgear.IGear;
import dev.toma.gunsrpg.util.ModUtils;
import java.util.Arrays;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;

public class StartGearManager
extends SingleJsonFileReloadListener {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(IGear.class, (Object)new GearAdapter()).registerTypeAdapter(ItemStack.class, (Object)new ItemStackAdapter()).create();
    private IGear gear;

    public StartGearManager() {
        super(GunsRPG.makeResource("starting_gear.json"), GSON);
    }

    protected void apply(JsonElement element, IResourceManager resourceManager, IProfiler profiler) {
        try {
            this.gear = (IGear)GSON.fromJson(element, IGear.class);
        }
        catch (JsonParseException jpe) {
            GunsRPG.log.error("Exception loading start gear data file " + (Object)((Object)jpe));
        }
    }

    public void giveStartingGear(PlayerEntity player) {
        if (this.gear == null) {
            GunsRPG.log.error("Couldn't give player ({}) his starting gear as gear data is null.", (Object)player.func_145748_c_());
            return;
        }
        Arrays.stream(this.gear.getGearItems(player.field_70170_p)).map(ItemStack::func_77946_l).forEach(item -> ModUtils.addItem(player, item));
    }
}

